/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.skcraft.concurrency.Deferred;
import com.skcraft.concurrency.Deferreds;
import com.skcraft.concurrency.SettableProgress;
import com.skcraft.launcher.creator.Creator;
import com.skcraft.launcher.creator.controller.PackManagerController;
import com.skcraft.launcher.creator.dialog.AboutDialog;
import com.skcraft.launcher.creator.dialog.PackManagerFrame;
import com.skcraft.launcher.creator.dialog.WelcomeDialog;
import com.skcraft.launcher.creator.model.creator.RecentEntry;
import com.skcraft.launcher.creator.model.creator.Workspace;
import com.skcraft.launcher.creator.model.swing.RecentListModel;
import com.skcraft.launcher.creator.swing.WorkspaceDirectoryFilter;
import com.skcraft.launcher.dialog.ProgressDialog;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.swing.PopupMouseAdapter;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.MorePaths;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class WelcomeController {
    private final WelcomeDialog dialog;
    private final Creator creator;
    private final RecentListModel recentListModel;

    public WelcomeController(WelcomeDialog dialog, Creator creator) {
        this.dialog = dialog;
        this.creator = creator;
        this.initListeners();
        this.recentListModel = new RecentListModel(creator.getConfig().getRecentEntries());
        dialog.getRecentList().setModel(this.recentListModel);
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    private boolean openWorkspace(File dir) {
        ListeningExecutorService executor = this.creator.getExecutor();
        PackManagerFrame frame = new PackManagerFrame();
        Deferred<PackManagerController> deferred = Deferreds.makeDeferred(executor.submit(() -> {
            PackManagerController controller = new PackManagerController(frame, dir, this.creator);
            this.addRecentEntry(dir);
            return controller;
        }), executor).handleAsync(PackManagerController::show, ex -> {}, SwingExecutor.INSTANCE);
        ProgressDialog.showProgress(frame, deferred, new SettableProgress("Loading...", -1.0), "Loading workspace...", "Loading workspace...");
        SwingHelper.addErrorDialogCallback(frame, deferred);
        return true;
    }

    private void addRecentEntry(File dir) {
        List newEntries = this.creator.getConfig().getRecentEntries().stream().filter(entry -> {
            try {
                return !MorePaths.isSamePath(entry.getPath(), dir);
            }
            catch (IOException ignored) {
                return false;
            }
        }).collect(Collectors.toCollection(Lists::newArrayList));
        RecentEntry recent = new RecentEntry();
        recent.setPath(dir);
        newEntries.add(0, recent);
        this.creator.getConfig().setRecentEntries(newEntries);
        Persistence.commitAndForget(this.creator.getConfig());
        this.recentListModel.fireUpdate();
    }

    private void removeRecentEntry(RecentEntry entry) {
        this.creator.getConfig().getRecentEntries().remove(entry);
        Persistence.commitAndForget(this.creator.getConfig());
        this.recentListModel.fireUpdate();
    }

    private Optional<RecentEntry> getSelectedRecentEntry() {
        int selectedIndex = this.dialog.getRecentList().getSelectedIndex();
        if (selectedIndex >= 0) {
            return Optional.fromNullable(this.creator.getConfig().getRecentEntries().get(selectedIndex));
        }
        return Optional.absent();
    }

    private Optional<File> getWorkspaceDir() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Workspace Directory");
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(new WorkspaceDirectoryFilter());
        int returnVal = chooser.showOpenDialog(this.dialog);
        if (returnVal == 0) {
            return Optional.fromNullable(chooser.getSelectedFile());
        }
        return Optional.absent();
    }

    private void initListeners() {
        this.dialog.getRecentList().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point point;
                JList table;
                int selectedIndex;
                if (e.getClickCount() == 2 && (selectedIndex = (table = (JList)e.getSource()).locationToIndex(point = e.getPoint())) >= 0) {
                    table.setSelectedIndex(selectedIndex);
                    Optional optional = WelcomeController.this.getSelectedRecentEntry();
                    if (optional.isPresent() && WelcomeController.this.openWorkspace(((RecentEntry)optional.get()).getPath())) {
                        WelcomeController.this.dialog.dispose();
                    }
                }
            }
        });
        this.dialog.getRecentList().addMouseListener(new PopupMouseAdapter(){

            @Override
            protected void showPopup(MouseEvent e) {
                Point point;
                JList table = (JList)e.getSource();
                int selectedIndex = table.locationToIndex(point = e.getPoint());
                if (selectedIndex >= 0) {
                    table.setSelectedIndex(selectedIndex);
                    Optional optional = WelcomeController.this.getSelectedRecentEntry();
                    if (optional.isPresent()) {
                        WelcomeController.this.popupRecentWorkspaceMenu(e.getComponent(), e.getX(), e.getY(), (RecentEntry)optional.get());
                    }
                }
            }
        });
        this.dialog.getNewButton().addActionListener(e -> {
            File workspaceFile;
            Optional<File> optional = this.getWorkspaceDir();
            if (optional.isPresent() && (!(workspaceFile = Workspace.getWorkspaceFile(optional.get())).exists() || SwingHelper.confirmDialog(this.dialog, "There is already a workspace there. Do you want to load it?", "Existing")) && this.openWorkspace(optional.get())) {
                this.dialog.dispose();
            }
        });
        this.dialog.getOpenButton().addActionListener(e -> {
            File workspaceFile;
            Optional<File> optional = this.getWorkspaceDir();
            if (optional.isPresent() && ((workspaceFile = Workspace.getWorkspaceFile(optional.get())).exists() || SwingHelper.confirmDialog(this.dialog, "Do you want to create a new workspace there?", "Create New")) && this.openWorkspace(optional.get())) {
                this.dialog.dispose();
            }
        });
        this.dialog.getHelpButton().addActionListener(e -> SwingHelper.openURL("https://github.com/SKCraft/Launcher/wiki", (Component)this.dialog));
        this.dialog.getAboutButton().addActionListener(e -> AboutDialog.showAboutDialog(this.dialog));
        this.dialog.getQuitButton().addActionListener(e -> this.dialog.dispose());
    }

    private void popupRecentWorkspaceMenu(Component component, int x, int y, RecentEntry entry) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Remove");
        menuItem.addActionListener(e -> this.removeRecentEntry(entry));
        popup.add(menuItem);
        popup.show(component, x, y);
    }
}

