/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.skcraft.concurrency.Deferred;
import com.skcraft.concurrency.Deferreds;
import com.skcraft.concurrency.SettableProgress;
import com.skcraft.launcher.creator.controller.task.DirectoryWalker;
import com.skcraft.launcher.creator.dialog.VersionCheckDialog;
import com.skcraft.launcher.creator.model.creator.ModFile;
import com.skcraft.launcher.creator.model.swing.ModFileTableModel;
import com.skcraft.launcher.creator.util.ModInfoReader;
import com.skcraft.launcher.creator.util.NemModList;
import com.skcraft.launcher.dialog.ProgressDialog;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.JTable;

public class VersionCheckController {
    private final VersionCheckDialog dialog;
    private final ListeningExecutorService executor;

    public VersionCheckController(VersionCheckDialog dialog, ListeningExecutorService executor) {
        this.dialog = dialog;
        this.executor = executor;
    }

    public void showUpdates(File dir, String gameVersion, Window parentWindow) {
        this.initListeners();
        DirectoryWalker walker = new DirectoryWalker(dir);
        walker.setRecursive(false);
        walker.setFileFilter(pathname -> pathname.getName().endsWith(".jar"));
        ModInfoReader binaryInspector = new ModInfoReader();
        NemModList nemModList = new NemModList();
        SettableProgress progress = new SettableProgress("Retrieving mod information...", -1.0);
        Deferred<List> deferred = Deferreds.makeDeferred(this.executor.submit(walker), this.executor).thenTap(() -> progress.set("Querying NotEnoughMods for version data...", -1.0)).thenTap(() -> {
            try {
                nemModList.load(gameVersion);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed to retrieve mod information from NotEnoughMods. Perhaps NEM doesn't support your pack's MC version.", e);
            }
        }).thenTap(() -> progress.set("Scanning mod files for manifests...", -1.0)).thenApply(files -> {
            ArrayList<ModFile> mods = Lists.newArrayList();
            for (File file : files) {
                NemModList.ModEntry entry;
                ModFile mod = new ModFile();
                mod.setGameVersion(gameVersion);
                mod.setFile(file);
                List<? extends ModInfoReader.ModInfo> infoList = binaryInspector.detectMods(file);
                if (!infoList.isEmpty()) {
                    ModInfoReader.ModInfo info = infoList.get(0);
                    mod.setModId(info.getModId());
                    mod.setName(info.getName());
                    mod.setVersion(info.getVersion());
                    if (info.getUrl() != null) {
                        mod.setUrl(VersionCheckController.getFirstUrl(info.getUrl(), "http://" + info.getUrl()));
                    }
                }
                if (mod.getModId() != null && (entry = nemModList.get(mod.getModId())) != null) {
                    mod.setLatestVersion(entry.getLatestVersion());
                    mod.setLatestDevVersion(entry.getLatestDevVersion());
                    if (entry.getUrl() != null) {
                        mod.setUrl(entry.getUrl());
                    }
                }
                mods.add(mod);
            }
            return mods;
        }).handleAsync(mods -> {
            ArrayList<ModFile> known = Lists.newArrayList();
            ArrayList<ModFile> unknown = Lists.newArrayList();
            for (ModFile mod : mods) {
                if (mod.getVersion() != null && mod.getLatestVersion() != null) {
                    if (mod.getCleanVersion().equals(mod.getLatestVersion()) || mod.getCleanVersion().equals(mod.getLatestDevVersion())) continue;
                    known.add(mod);
                    continue;
                }
                unknown.add(mod);
            }
            this.dialog.getKnownModsTable().setModel(new ModFileTableModel(known));
            this.dialog.getUnknownModsTable().setModel(new ModFileTableModel(unknown));
            this.dialog.getKnownModsTable().getRowSorter().toggleSortOrder(1);
            this.dialog.getUnknownModsTable().getRowSorter().toggleSortOrder(1);
            this.dialog.setVisible(true);
        }, ex -> {}, SwingExecutor.INSTANCE);
        ProgressDialog.showProgress(parentWindow, deferred, progress, "Checking for mod updates...", "Checking for mod updates...");
        SwingHelper.addErrorDialogCallback(parentWindow, deferred);
    }

    private void initListeners() {
        this.dialog.getCloseButton().addActionListener(e -> this.dialog.dispose());
        ModTableMouseListener mouseListener = new ModTableMouseListener();
        this.dialog.getKnownModsTable().addMouseListener(mouseListener);
        this.dialog.getUnknownModsTable().addMouseListener(mouseListener);
    }

    @Nullable
    private static URL getFirstUrl(String ... options) {
        for (String option : options) {
            try {
                return new URL(option);
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return null;
    }

    private class ModTableMouseListener
    extends MouseAdapter {
        private ModTableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point point;
            JTable table;
            int selectedIndex;
            if (e.getClickCount() == 2 && (selectedIndex = (table = (JTable)e.getSource()).rowAtPoint(point = e.getPoint())) >= 0) {
                selectedIndex = table.convertRowIndexToModel(selectedIndex);
                ModFile mod = ((ModFileTableModel)table.getModel()).getMod(selectedIndex);
                if (mod != null && mod.getUrl() != null) {
                    SwingHelper.openURL(mod.getUrl(), (Component)VersionCheckController.this.dialog);
                }
            }
        }
    }
}

