/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.skcraft.concurrency.Deferred;
import com.skcraft.concurrency.Deferreds;
import com.skcraft.concurrency.SettableProgress;
import com.skcraft.launcher.creator.controller.ManifestEntryController;
import com.skcraft.launcher.creator.dialog.GenerateListingDialog;
import com.skcraft.launcher.creator.dialog.ManifestEntryDialog;
import com.skcraft.launcher.creator.model.creator.ManifestEntry;
import com.skcraft.launcher.creator.model.creator.Workspace;
import com.skcraft.launcher.creator.model.swing.ListingType;
import com.skcraft.launcher.creator.model.swing.ManifestEntryTableModel;
import com.skcraft.launcher.dialog.ProgressDialog;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTable;

public class GenerateListingController {
    private final GenerateListingDialog dialog;
    private final Workspace workspace;
    private final List<ManifestEntry> manifestEntries;
    private final ListeningExecutorService executor;
    private final ManifestEntryTableModel manifestTableModel;

    public GenerateListingController(GenerateListingDialog dialog, Workspace workspace, List<ManifestEntry> manifestEntries, ListeningExecutorService executor) {
        this.dialog = dialog;
        this.workspace = workspace;
        this.manifestEntries = manifestEntries;
        this.executor = executor;
        this.manifestTableModel = new ManifestEntryTableModel(manifestEntries);
        dialog.getManifestsTable().setModel(this.manifestTableModel);
        dialog.getManifestsTableAdjuster().adjustColumns();
        this.initListeners();
        this.setListingType(workspace.getPackageListingType());
    }

    public void setOutputDir(File dir) {
        this.dialog.getDestDirField().setPath(dir.getAbsolutePath());
    }

    public void setListingType(ListingType type) {
        this.dialog.getListingTypeCombo().setSelectedItem((Object)type);
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    public Optional<ManifestEntry> getManifestFromIndex(int selectedIndex) {
        ManifestEntry manifest;
        if (selectedIndex >= 0 && (manifest = this.manifestEntries.get(selectedIndex)) != null) {
            return Optional.fromNullable(manifest);
        }
        return Optional.absent();
    }

    public Optional<ManifestEntry> getSelectedManifest() {
        ManifestEntry manifest;
        JTable table = this.dialog.getManifestsTable();
        int selectedIndex = table.getSelectedRow();
        if (selectedIndex >= 0 && (manifest = this.manifestEntries.get(selectedIndex = table.convertRowIndexToModel(selectedIndex))) != null) {
            return Optional.fromNullable(manifest);
        }
        SwingHelper.showErrorDialog(this.dialog, "Please select a modpack from the list.", "Error");
        return Optional.absent();
    }

    private void updateManifestEntryInTable(ManifestEntry manifestEntry) {
        int index = this.manifestEntries.indexOf(manifestEntry);
        if (index >= 0) {
            this.manifestTableModel.fireTableRowsUpdated(index, index);
        }
    }

    private void initListeners() {
        this.dialog.getManifestsTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Optional<ManifestEntry> optional;
                Point point;
                JTable table;
                int selectedIndex;
                if (e.getClickCount() == 2 && (selectedIndex = (table = (JTable)e.getSource()).rowAtPoint(point = e.getPoint())) >= 0 && (optional = GenerateListingController.this.getManifestFromIndex(selectedIndex = table.convertRowIndexToModel(selectedIndex))).isPresent() && GenerateListingController.this.showModifyDialog(optional.get())) {
                    GenerateListingController.this.updateManifestEntryInTable(optional.get());
                }
            }
        });
        this.dialog.getListingTypeCombo().addItemListener(e -> {
            ListingType type = (ListingType)((Object)((Object)e.getItem()));
            this.dialog.getGameKeyWarning().setVisible(!type.isGameKeyCompatible());
        });
        this.dialog.getEditManifestButton().addActionListener(e -> {
            Optional<ManifestEntry> optional = this.getSelectedManifest();
            if (optional.isPresent() && this.showModifyDialog(optional.get())) {
                this.updateManifestEntryInTable(optional.get());
            }
        });
        this.dialog.getGenerateButton().addActionListener(e -> this.tryGenerate());
        this.dialog.getCancelButton().addActionListener(e -> this.dialog.dispose());
    }

    private boolean showModifyDialog(ManifestEntry manifestEntry) {
        ManifestEntryDialog modifyDialog = new ManifestEntryDialog((Window)this.dialog);
        modifyDialog.setTitle("Modify " + manifestEntry.getManifestInfo().getLocation());
        ManifestEntryController controller = new ManifestEntryController(modifyDialog, manifestEntry);
        return controller.show();
    }

    private boolean tryGenerate() {
        String path = this.dialog.getDestDirField().getPath().trim();
        if (path.isEmpty()) {
            SwingHelper.showErrorDialog(this.dialog, "A directory must be entered.", "Error");
            return false;
        }
        List selected = this.manifestEntries.stream().filter(ManifestEntry::isSelected).sorted().collect(Collectors.toCollection(Lists::newArrayList));
        if (selected.isEmpty()) {
            SwingHelper.showErrorDialog(this.dialog, "At least one modpack must be selected to appear in the package list.", "Error");
            return false;
        }
        ListingType listingType = (ListingType)((Object)this.dialog.getListingTypeCombo().getSelectedItem());
        File destDir = new File(path);
        destDir.mkdirs();
        File file = new File(destDir, listingType.getFilename());
        this.workspace.setPackageListingEntries(selected);
        this.workspace.setPackageListingType(listingType);
        Persistence.commitAndForget(this.workspace);
        SettableProgress progress = new SettableProgress("Generating package listing...", -1.0);
        Deferred<File> deferred = Deferreds.makeDeferred(this.executor.submit(() -> listingType.generate(selected))).thenTap(() -> progress.set("Deleting older package listing files...", -1.0)).thenApply(input -> {
            for (ListingType otherListingType : ListingType.values()) {
                File f = new File(destDir, otherListingType.getFilename());
                if (!f.exists()) continue;
                f.delete();
            }
            return input;
        }).thenTap(() -> progress.set("Writing package listing to disk...", -1.0)).thenApply(input -> {
            try {
                Files.write(input, file, Charset.forName("UTF-8"));
                return file;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write package listing file to disk", e);
            }
        }).handleAsync(v -> {
            if (listingType.isGameKeyCompatible()) {
                SwingHelper.showMessageDialog(this.dialog, "Successfully generated package listing.", "Success", null, 1);
            } else {
                SwingHelper.showMessageDialog(this.dialog, "Successfully generated package listing.\n\nNote that any modpacks with game keys set were not added.", "Success", null, 1);
            }
            this.dialog.dispose();
            SwingHelper.browseDir(destDir, this.dialog);
        }, ex -> {}, SwingExecutor.INSTANCE);
        ProgressDialog.showProgress(this.dialog, deferred, progress, "Writing package listing...", "Writing package listing...");
        SwingHelper.addErrorDialogCallback(this.dialog, deferred);
        return true;
    }
}

