/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.creator.controller.WelcomeController;
import com.skcraft.launcher.creator.dialog.WelcomeDialog;
import com.skcraft.launcher.creator.model.creator.CreatorConfig;
import com.skcraft.launcher.creator.model.creator.RecentEntry;
import com.skcraft.launcher.creator.model.creator.Workspace;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.swing.SwingHelper;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class Creator {
    private final File dataDir;
    private final CreatorConfig config;
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator(Executors.newCachedThreadPool());

    public Creator() {
        this.dataDir = Creator.getAppDataDir();
        this.config = Persistence.load(new File(this.dataDir, "config.json"), CreatorConfig.class);
        List<RecentEntry> recentEntries = this.config.getRecentEntries();
        Iterator<RecentEntry> it = recentEntries.iterator();
        while (it.hasNext()) {
            RecentEntry workspace = it.next();
            if (Workspace.getWorkspaceFile(workspace.getPath()).exists()) continue;
            it.remove();
        }
    }

    public void showWelcome() {
        WelcomeDialog dialog = new WelcomeDialog();
        WelcomeController controller = new WelcomeController(dialog, this);
        controller.show();
    }

    private static File getFileChooseDefaultDir() {
        JFileChooser chooser = new JFileChooser();
        FileSystemView fsv = chooser.getFileSystemView();
        return fsv.getDefaultDirectory();
    }

    private static File getAppDataDir() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return new File(Creator.getFileChooseDefaultDir(), "SKCraft Modpack Creator");
        }
        return new File(System.getProperty("user.home"), ".skcraftcreator");
    }

    public static void main(String[] args) throws Exception {
        Launcher.setupLogger();
        System.setProperty("skcraftLauncher.killWithoutConfirm", "true");
        Creator creator = new Creator();
        SwingUtilities.invokeAndWait(() -> {
            SwingHelper.setSwingProperties("Modpack Creator");
            SwingHelper.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            try {
                creator.showWelcome();
            }
            catch (Exception e) {
                SwingHelper.showErrorDialog(null, "Failed to start the modpack creator program.", "Start Error", e);
            }
        });
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public CreatorConfig getConfig() {
        return this.config;
    }

    public ListeningExecutorService getExecutor() {
        return this.executor;
    }
}

