/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder.loaders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.skcraft.launcher.builder.BuilderUtils;
import com.skcraft.launcher.builder.loaders.ILoaderProcessor;
import com.skcraft.launcher.builder.loaders.LoaderResult;
import com.skcraft.launcher.model.loader.profiles.LegacyInstallProfile;
import com.skcraft.launcher.model.minecraft.GameArgument;
import com.skcraft.launcher.model.minecraft.Library;
import com.skcraft.launcher.model.minecraft.MinecraftArguments;
import com.skcraft.launcher.model.minecraft.VersionManifest;
import com.skcraft.launcher.model.modpack.Manifest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class OldForgeLoaderProcessor
implements ILoaderProcessor {
    private static final Logger log = Logger.getLogger(OldForgeLoaderProcessor.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoaderResult process(File loaderJar, Manifest manifest, ObjectMapper mapper, File baseDir) throws IOException {
        JarFile jarFile = new JarFile(loaderJar);
        LoaderResult result = new LoaderResult();
        Closer closer = Closer.create();
        try {
            ZipEntry profileEntry = BuilderUtils.getZipEntry(jarFile, "install_profile.json");
            if (profileEntry != null) {
                String mainClass;
                List<Library> libraries;
                InputStream stream = jarFile.getInputStream(profileEntry);
                String data = BuilderUtils.readStringFromStream(closer.register(new InputStreamReader(stream)));
                LegacyInstallProfile profile = mapper.readValue(data, LegacyInstallProfile.class);
                VersionManifest version = manifest.getVersionManifest();
                MinecraftArguments args = profile.getVersionInfo().getArguments();
                if (args != null) {
                    Iterator<GameArgument> iter = args.getGameArguments().iterator();
                    while (iter.hasNext()) {
                        GameArgument cur = iter.next();
                        if (!cur.getValues().contains("--tweakClass")) continue;
                        String tweakClass = cur.getValues().size() > 1 ? cur.getValues().get(1) : iter.next().getJoinedValue();
                        List<GameArgument> gameArgs = manifest.getVersionManifest().getArguments().getGameArguments();
                        gameArgs.add(new GameArgument("--tweakClass"));
                        gameArgs.add(new GameArgument(tweakClass));
                        log.info(String.format("Adding tweak class '%s' to arguments", tweakClass));
                    }
                }
                if ((libraries = profile.getVersionInfo().getLibraries()) != null) {
                    for (Library library : libraries) {
                        if (version.getLibraries().contains(library)) continue;
                        result.getLoaderLibraries().add(library);
                    }
                }
                if ((mainClass = profile.getVersionInfo().getMainClass()) != null) {
                    version.setMainClass(mainClass);
                    log.info("Using " + mainClass + " as the main class");
                }
                String filePath = profile.getInstallData().getFilePath();
                String libraryPath = profile.getInstallData().getPath();
                if (filePath != null && libraryPath != null) {
                    ZipEntry libraryEntry = BuilderUtils.getZipEntry(jarFile, filePath);
                    if (libraryEntry != null) {
                        File librariesDir = new File(baseDir, "libraries");
                        File extractPath = new File(librariesDir, Library.mavenNameToPath(libraryPath));
                        Files.createParentDirs(extractPath);
                        ByteStreams.copy(closer.register(jarFile.getInputStream(libraryEntry)), Files.newOutputStreamSupplier(extractPath));
                    } else {
                        log.warning("Could not find the file '" + filePath + "' in " + loaderJar.getAbsolutePath() + ", which means that this mod loader will not work correctly");
                    }
                }
            } else {
                log.warning("The file at " + loaderJar.getAbsolutePath() + " did not appear to have an install_profile.json file inside -- is it actually an installer for a mod loader?");
            }
        }
        finally {
            closer.close();
            jarFile.close();
        }
        return result;
    }
}

