/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder.loaders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import com.skcraft.launcher.builder.BuilderUtils;
import com.skcraft.launcher.builder.loaders.ILoaderProcessor;
import com.skcraft.launcher.builder.loaders.LoaderResult;
import com.skcraft.launcher.model.loader.LoaderManifest;
import com.skcraft.launcher.model.loader.SidedData;
import com.skcraft.launcher.model.loader.VersionInfo;
import com.skcraft.launcher.model.loader.profiles.ModernForgeInstallProfile;
import com.skcraft.launcher.model.minecraft.GameArgument;
import com.skcraft.launcher.model.minecraft.Library;
import com.skcraft.launcher.model.minecraft.Side;
import com.skcraft.launcher.model.minecraft.VersionManifest;
import com.skcraft.launcher.model.modpack.DownloadableFile;
import com.skcraft.launcher.model.modpack.Manifest;
import com.skcraft.launcher.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class ModernForgeLoaderProcessor
implements ILoaderProcessor {
    private static final Logger log = Logger.getLogger(ModernForgeLoaderProcessor.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoaderResult process(File loaderJar, Manifest manifest, ObjectMapper mapper, File baseDir) throws IOException {
        JarFile jarFile = new JarFile(loaderJar);
        Closer closer = Closer.create();
        LoaderResult result = new LoaderResult();
        try {
            ZipEntry mavenEntry;
            ZipEntry versionEntry = BuilderUtils.getZipEntry(jarFile, "version.json");
            String loaderName = jarFile.getName();
            if (versionEntry != null) {
                String mainClass;
                SidedData<VersionManifest.LoggingConfig> loggingConfig;
                List<Library> libraries;
                List<GameArgument> jvmArguments;
                List<GameArgument> gameArguments;
                InputStream stream = jarFile.getInputStream(versionEntry);
                VersionInfo info = mapper.readValue(BuilderUtils.readStringFromStream(closer.register(new InputStreamReader(stream))), VersionInfo.class);
                VersionManifest version = manifest.getVersionManifest();
                if (info.getId() != null) {
                    loaderName = info.getId();
                }
                if ((gameArguments = info.getArguments().getGameArguments()) != null) {
                    if (info.isOverridingArguments()) {
                        version.getArguments().getGameArguments().clear();
                    }
                    version.getArguments().getGameArguments().addAll(gameArguments);
                }
                if ((jvmArguments = info.getArguments().getJvmArguments()) != null) {
                    version.getArguments().getJvmArguments().addAll(jvmArguments);
                }
                if ((libraries = info.getLibraries()) != null) {
                    for (Library library : libraries) {
                        result.getLoaderLibraries().add(library);
                        log.info("Adding loader library " + library.getName());
                    }
                }
                if ((loggingConfig = info.getLogging()) != null) {
                    version.setLogging(loggingConfig);
                }
                if ((mainClass = info.getMainClass()) != null) {
                    version.setMainClass(mainClass);
                    log.info("Using " + mainClass + " as the main class");
                }
            } else {
                log.warning("The loader " + loaderJar.getAbsolutePath() + " does not appear to have a version.json file inside -- is it actually an installer for Forge?");
            }
            ZipEntry profileEntry = BuilderUtils.getZipEntry(jarFile, "install_profile.json");
            if (profileEntry != null) {
                DownloadableFile entry;
                ZipEntry serverBinpatch;
                InputStream stream = jarFile.getInputStream(profileEntry);
                String data = CharStreams.toString(closer.register(new InputStreamReader(stream)));
                ModernForgeInstallProfile profile = mapper.readValue(data = data.replace(",\\s*\\}", "}"), ModernForgeInstallProfile.class);
                if (!profile.getMinecraft().equals(manifest.getGameVersion())) {
                    log.warning(String.format("The Forge installer inside loaders/ is for Minecraft version %s; your manifest is set to %s.", profile.getMinecraft(), manifest.getGameVersion()));
                }
                result.getProcessorLibraries().addAll(profile.getLibraries());
                ArrayList<DownloadableFile> extraFiles = Lists.newArrayList();
                File objectsDir = new File(baseDir, manifest.getObjectsLocation());
                ZipEntry clientBinpatch = BuilderUtils.getZipEntry(jarFile, "data/client.lzma");
                if (clientBinpatch != null) {
                    DownloadableFile entry2 = FileUtils.saveStreamToObjectsDir(closer.register(jarFile.getInputStream(clientBinpatch)), objectsDir);
                    entry2.setName("client.lzma");
                    entry2.setSide(Side.CLIENT);
                    extraFiles.add(entry2);
                    profile.getData().get("BINPATCH").setClient("&" + entry2.getName() + "&");
                }
                if ((serverBinpatch = BuilderUtils.getZipEntry(jarFile, "data/server.lzma")) != null) {
                    entry = FileUtils.saveStreamToObjectsDir(closer.register(jarFile.getInputStream(serverBinpatch)), objectsDir);
                    entry.setName("server.lzma");
                    entry.setSide(Side.SERVER);
                    extraFiles.add(entry);
                    profile.getData().get("BINPATCH").setServer("&" + entry.getName() + "&");
                }
                if (profile.getSpec() >= 1) {
                    entry = FileUtils.saveStreamToObjectsDir(closer.register(new FileInputStream(loaderJar)), objectsDir);
                    entry.setName(loaderJar.getName());
                    entry.setSide(Side.SERVER);
                    extraFiles.add(entry);
                    profile.getData().put("INSTALLER", SidedData.of("&" + entry.getName() + "&"));
                }
                profile.getData().put("SIDE", SidedData.create("client", "server"));
                manifest.getLoaders().put(loaderName, new LoaderManifest(profile.getLibraries(), profile.getData(), extraFiles));
                SidedData<String> finalJars = profile.getData().get("PATCHED");
                if (finalJars != null) {
                    String libraryName = finalJars.getClient();
                    libraryName = libraryName.substring(1, libraryName.length() - 1);
                    for (Library lib : result.getLoaderLibraries()) {
                        if (!lib.matches(libraryName)) continue;
                        lib.setGenerated(true);
                        log.info(String.format("Setting generated flag on library '%s'", lib.getName()));
                        break;
                    }
                }
                manifest.getTasks().addAll(profile.toProcessorEntries(loaderName));
            }
            if ((mavenEntry = BuilderUtils.getZipEntry(jarFile, "maven/")) != null) {
                URL jarUrl = new URL("jar:file:" + loaderJar.getAbsolutePath() + "!/");
                result.getJarMavens().add(new URL(jarUrl, "/maven/"));
            }
        }
        finally {
            closer.close();
            jarFile.close();
        }
        return result;
    }
}

