/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import com.beust.jcommander.JCommander;
import com.google.common.io.Files;
import com.skcraft.launcher.builder.DirectoryWalker;
import com.skcraft.launcher.builder.ServerExportOptions;
import com.skcraft.launcher.util.SimpleLogFormatter;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import lombok.NonNull;

public class ServerCopyExport
extends DirectoryWalker {
    private static final Logger log = Logger.getLogger(ServerCopyExport.class.getName());
    private final File destDir;

    public ServerCopyExport(@NonNull File destDir) {
        if (destDir == null) {
            throw new NullPointerException("destDir is marked non-null but is null");
        }
        this.destDir = destDir;
    }

    @Override
    protected DirectoryWalker.DirectoryBehavior getBehavior(String name) {
        if (name.startsWith(".")) {
            return DirectoryWalker.DirectoryBehavior.SKIP;
        }
        if (name.equals("_SERVER")) {
            return DirectoryWalker.DirectoryBehavior.IGNORE;
        }
        if (name.equals("_CLIENT")) {
            return DirectoryWalker.DirectoryBehavior.SKIP;
        }
        return DirectoryWalker.DirectoryBehavior.CONTINUE;
    }

    @Override
    protected void onFile(File file, String relPath) throws IOException {
        File dest = new File(this.destDir, relPath);
        log.info("Copying " + file.getAbsolutePath() + " to " + dest.getAbsolutePath());
        dest.getParentFile().mkdirs();
        Files.copy(file, dest);
    }

    public static void main(String[] args) throws IOException {
        SimpleLogFormatter.configureGlobalLogger();
        ServerExportOptions options = new ServerExportOptions();
        new JCommander((Object)options, args);
        log.info("From: " + options.getSourceDir().getAbsolutePath());
        log.info("To: " + options.getDestDir().getAbsolutePath());
        ServerCopyExport task = new ServerCopyExport(options.getDestDir());
        task.walk(options.getSourceDir());
    }
}

