/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.skcraft.launcher.builder.FnMatch;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public class FnPatternList {
    private static final EnumSet<FnMatch.Flag> DEFAULT_FLAGS = EnumSet.of(FnMatch.Flag.CASEFOLD, FnMatch.Flag.PERIOD);
    private List<String> include = Lists.newArrayList();
    private List<String> exclude = Lists.newArrayList();
    @JsonIgnore
    private EnumSet<FnMatch.Flag> flags = DEFAULT_FLAGS;

    public void setInclude(List<String> include) {
        this.include = include != null ? include : Lists.newArrayList();
    }

    public void setExclude(List<String> exclude) {
        this.exclude = exclude != null ? exclude : Lists.newArrayList();
    }

    public boolean matches(String path) {
        return this.include != null && this.matches(path, this.include) && (this.exclude == null || !this.matches(path, this.exclude));
    }

    public boolean matches(String path, Collection<String> patterns) {
        for (String pattern : patterns) {
            if (!FnMatch.fnmatch(pattern, path, this.flags)) continue;
            return true;
        }
        return false;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public List<String> getExclude() {
        return this.exclude;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FnPatternList)) {
            return false;
        }
        FnPatternList other = (FnPatternList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$include = this.getInclude();
        List<String> other$include = other.getInclude();
        if (this$include == null ? other$include != null : !((Object)this$include).equals(other$include)) {
            return false;
        }
        List<String> this$exclude = this.getExclude();
        List<String> other$exclude = other.getExclude();
        if (this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude)) {
            return false;
        }
        EnumSet<FnMatch.Flag> this$flags = this.getFlags();
        EnumSet<FnMatch.Flag> other$flags = other.getFlags();
        return !(this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FnPatternList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $include = this.getInclude();
        result = result * 59 + ($include == null ? 43 : ((Object)$include).hashCode());
        List<String> $exclude = this.getExclude();
        result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
        EnumSet<FnMatch.Flag> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        return result;
    }

    public String toString() {
        return "FnPatternList(include=" + this.getInclude() + ", exclude=" + this.getExclude() + ", flags=" + this.getFlags() + ")";
    }

    public EnumSet<FnMatch.Flag> getFlags() {
        return this.flags;
    }

    @JsonIgnore
    public void setFlags(EnumSet<FnMatch.Flag> flags) {
        this.flags = flags;
    }
}

