/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import com.google.common.io.Files;
import com.skcraft.launcher.builder.DirectoryWalker;
import com.skcraft.launcher.builder.FileUrlRedirect;
import com.skcraft.launcher.util.FileUtils;
import com.skcraft.launcher.util.HttpRequest;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class FileUrlScanner
extends DirectoryWalker {
    private static final Logger log = Logger.getLogger(FileUrlScanner.class.getName());
    public static final String URL_FILE_SUFFIX = ".url.txt";

    public static boolean isEnabled() {
        return !System.getProperty("com.skcraft.builder.ignoreURLOverrides", "false").equalsIgnoreCase("true");
    }

    @Override
    protected void onFile(File file, String relPath) throws IOException {
        if (!file.getName().endsWith(URL_FILE_SUFFIX)) {
            return;
        }
        log.info("Found URL file " + file.getName());
        File targetFile = new File(file.getAbsoluteFile().getParentFile(), file.getName().replace(URL_FILE_SUFFIX, ""));
        FileUrlRedirect info = FileUrlRedirect.fromFile(file);
        if (targetFile.exists()) {
            String localHash = FileUtils.getShaHash(targetFile);
            if (info.getHash() == null) {
                return;
            }
            if (info.getHash().equals(localHash)) {
                return;
            }
        }
        File tempFile = File.createTempFile("launcherlib", null);
        try {
            log.info("Downloading file " + targetFile.getName() + " from " + info.getUrl() + "...");
            HttpRequest.get(info.getUrl()).execute().expectResponseCode(200).saveContent(tempFile);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        Files.move(tempFile, targetFile);
        log.info("Updated " + targetFile.getName() + " from " + file.getName());
    }
}

