/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import com.google.common.io.Files;
import com.skcraft.launcher.util.HttpRequest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;

public class FileUrlRedirect {
    private URL url;
    private String hash;

    public void readFromFile(File file) throws IOException {
        String hash;
        List<String> lines = Files.readLines(file, Charset.defaultCharset());
        this.url = HttpRequest.url(lines.get(0));
        if (lines.size() > 1 && !(hash = lines.get(1)).isEmpty()) {
            this.hash = hash;
        }
    }

    public void writeToFile(File file) throws IOException {
        String entry = this.url.toString() + '\n' + this.hash;
        Files.write(entry, file, Charset.defaultCharset());
    }

    public static FileUrlRedirect fromFile(File file) throws IOException {
        FileUrlRedirect entry = new FileUrlRedirect();
        entry.readFromFile(file);
        return entry;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getHash() {
        return this.hash;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileUrlRedirect)) {
            return false;
        }
        FileUrlRedirect other = (FileUrlRedirect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URL this$url = this.getUrl();
        URL other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileUrlRedirect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URL $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }

    public String toString() {
        return "FileUrlRedirect(url=" + this.getUrl() + ", hash=" + this.getHash() + ")";
    }
}

