/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import java.io.File;
import java.io.IOException;
import lombok.NonNull;

public abstract class DirectoryWalker {
    public final void walk(@NonNull File dir) throws IOException {
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        this.walk(dir, "");
    }

    private void walk(@NonNull File dir, @NonNull String basePath) throws IOException {
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        if (basePath == null) {
            throw new NullPointerException("basePath is marked non-null but is null");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " is not a directory");
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    String newPath = basePath;
                    switch (this.getBehavior(file.getName())) {
                        case CONTINUE: {
                            newPath = newPath + file.getName() + "/";
                        }
                        case IGNORE: {
                            this.walk(file, newPath);
                            break;
                        }
                    }
                    continue;
                }
                this.onFile(file, basePath + file.getName());
            }
        }
    }

    protected DirectoryBehavior getBehavior(String name) {
        return DirectoryBehavior.CONTINUE;
    }

    protected abstract void onFile(File var1, String var2) throws IOException;

    public static enum DirectoryBehavior {
        CONTINUE,
        IGNORE,
        SKIP;

    }
}

