/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class Compressor {
    private static final CompressorStreamFactory factory = new CompressorStreamFactory();
    private final String extension;
    private final String format;

    public Compressor(String extension, String format) {
        this.extension = extension;
        this.format = format;
    }

    public String transformPathname(String filename) {
        return filename + "." + this.extension;
    }

    public InputStream createInputStream(InputStream inputStream) throws IOException {
        try {
            return factory.createCompressorInputStream(this.format, inputStream);
        }
        catch (CompressorException e) {
            throw new IOException("Failed to create decompressor", e);
        }
    }

    public OutputStream createOutputStream(OutputStream outputStream) throws IOException {
        try {
            return factory.createCompressorOutputStream(this.format, outputStream);
        }
        catch (CompressorException e) {
            throw new IOException("Failed to create compressor", e);
        }
    }
}

