/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.skcraft.launcher.builder.DirectoryWalker;
import com.skcraft.launcher.builder.FileUrlRedirect;
import com.skcraft.launcher.builder.FileUrlScanner;
import com.skcraft.launcher.builder.PropertiesApplicator;
import com.skcraft.launcher.model.modpack.FileInstall;
import com.skcraft.launcher.model.modpack.Manifest;
import com.skcraft.launcher.model.modpack.ManifestEntry;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;

public class ClientFileCollector
extends DirectoryWalker {
    private static final Logger log = Logger.getLogger(ClientFileCollector.class.getName());
    private final Manifest manifest;
    private final PropertiesApplicator applicator;
    private final File destDir;
    private HashFunction hf = Hashing.sha1();

    public ClientFileCollector(@NonNull Manifest manifest, @NonNull PropertiesApplicator applicator, @NonNull File destDir) {
        if (manifest == null) {
            throw new NullPointerException("manifest is marked non-null but is null");
        }
        if (applicator == null) {
            throw new NullPointerException("applicator is marked non-null but is null");
        }
        if (destDir == null) {
            throw new NullPointerException("destDir is marked non-null but is null");
        }
        this.manifest = manifest;
        this.applicator = applicator;
        this.destDir = destDir;
    }

    @Override
    protected DirectoryWalker.DirectoryBehavior getBehavior(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return ClientFileCollector.getDirectoryBehavior(name);
    }

    @Override
    protected void onFile(File file, String relPath) throws IOException {
        String location;
        if (file.getName().endsWith(".info.json") || file.getName().endsWith(".url.txt")) {
            return;
        }
        FileInstall entry = new FileInstall();
        String hash = Files.hash(file, this.hf).toString();
        String to = FilenameUtils.separatorsToUnix(FilenameUtils.normalize(relPath));
        File urlFile = new File(file.getAbsoluteFile().getParentFile(), file.getName() + ".url.txt");
        boolean copy = true;
        if (urlFile.exists() && FileUrlScanner.isEnabled()) {
            FileUrlRedirect redirect = FileUrlRedirect.fromFile(urlFile);
            location = redirect.getUrl().toString();
            copy = false;
        } else {
            location = hash.substring(0, 2) + "/" + hash.substring(2, 4) + "/" + hash;
        }
        File destPath = new File(this.destDir, location);
        entry.setHash(hash);
        entry.setLocation(location);
        entry.setTo(to);
        entry.setSize(file.length());
        this.applicator.apply((ManifestEntry)entry);
        destPath.getParentFile().mkdirs();
        log.info(String.format("Adding %s from %s...", relPath, file.getAbsolutePath()));
        if (copy) {
            Files.copy(file, destPath);
        }
        this.manifest.getTasks().add(entry);
    }

    public static DirectoryWalker.DirectoryBehavior getDirectoryBehavior(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (name.startsWith(".")) {
            return DirectoryWalker.DirectoryBehavior.SKIP;
        }
        if (name.equals("_OPTIONAL")) {
            return DirectoryWalker.DirectoryBehavior.IGNORE;
        }
        if (name.equals("_SERVER")) {
            return DirectoryWalker.DirectoryBehavior.SKIP;
        }
        if (name.equals("_CLIENT")) {
            return DirectoryWalker.DirectoryBehavior.IGNORE;
        }
        return DirectoryWalker.DirectoryBehavior.CONTINUE;
    }
}

