/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.skcraft.launcher.builder.Compressor;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class BuilderUtils {
    private static final DateFormat VERSION_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");

    private BuilderUtils() {
    }

    public static String normalizePath(String path) {
        return path.replaceAll("^[/\\\\]*", "").replaceAll("[/\\\\]+", "/");
    }

    public static ZipEntry getZipEntry(ZipFile jarFile, String path) {
        Enumeration<? extends ZipEntry> entries = jarFile.entries();
        String expected = BuilderUtils.normalizePath(path);
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String test = BuilderUtils.normalizePath(entry.getName());
            if (!expected.equals(test)) continue;
            return entry;
        }
        return null;
    }

    public static String readStringFromStream(Readable r) throws IOException {
        String data = CharStreams.toString(r);
        data = data.replaceAll(",\\s*\\}", "}");
        return data;
    }

    public static List<Compressor> getCompressors(String repoUrl) {
        if (repoUrl.matches("^https?://files.minecraftforge.net/maven/?")) {
            return Lists.newArrayList(new Compressor("xz", "xz"), new Compressor("pack", "pack200"));
        }
        return Collections.emptyList();
    }

    public static String generateVersionFromDate() {
        Date today = Calendar.getInstance().getTime();
        return VERSION_DATE_FORMAT.format(today);
    }
}

