/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.skcraft.launcher.builder.FeaturePattern;
import com.skcraft.launcher.builder.FnPatternList;
import com.skcraft.launcher.builder.PropertiesApplicator;
import com.skcraft.launcher.model.modpack.LaunchModifier;
import com.skcraft.launcher.model.modpack.Manifest;
import java.util.List;

public class BuilderConfig {
    private String name;
    private String title;
    private String gameVersion;
    @JsonProperty(value="launch")
    private LaunchModifier launchModifier = new LaunchModifier();
    private List<FeaturePattern> features = Lists.newArrayList();
    private FnPatternList userFiles = new FnPatternList();

    public void setLaunchModifier(LaunchModifier launchModifier) {
        this.launchModifier = launchModifier != null ? launchModifier : new LaunchModifier();
    }

    public void setFeatures(List<FeaturePattern> features) {
        this.features = features != null ? features : Lists.newArrayList();
    }

    public void setUserFiles(FnPatternList userFiles) {
        this.userFiles = userFiles != null ? userFiles : new FnPatternList();
    }

    public void update(Manifest manifest) {
        manifest.updateName(this.getName());
        manifest.updateTitle(this.getTitle());
        manifest.updateGameVersion(this.getGameVersion());
        manifest.setLaunchModifier(this.getLaunchModifier());
    }

    public void registerProperties(PropertiesApplicator applicator) {
        if (this.features != null) {
            for (FeaturePattern feature : this.features) {
                Preconditions.checkNotNull(Strings.emptyToNull(feature.getFeature().getName()), "Empty feature name found");
                applicator.register(feature);
            }
        }
        applicator.setUserFiles(this.userFiles);
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public LaunchModifier getLaunchModifier() {
        return this.launchModifier;
    }

    public List<FeaturePattern> getFeatures() {
        return this.features;
    }

    public FnPatternList getUserFiles() {
        return this.userFiles;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setGameVersion(String gameVersion) {
        this.gameVersion = gameVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuilderConfig)) {
            return false;
        }
        BuilderConfig other = (BuilderConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$gameVersion = this.getGameVersion();
        String other$gameVersion = other.getGameVersion();
        if (this$gameVersion == null ? other$gameVersion != null : !this$gameVersion.equals(other$gameVersion)) {
            return false;
        }
        LaunchModifier this$launchModifier = this.getLaunchModifier();
        LaunchModifier other$launchModifier = other.getLaunchModifier();
        if (this$launchModifier == null ? other$launchModifier != null : !((Object)this$launchModifier).equals(other$launchModifier)) {
            return false;
        }
        List<FeaturePattern> this$features = this.getFeatures();
        List<FeaturePattern> other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        FnPatternList this$userFiles = this.getUserFiles();
        FnPatternList other$userFiles = other.getUserFiles();
        return !(this$userFiles == null ? other$userFiles != null : !((Object)this$userFiles).equals(other$userFiles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuilderConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $gameVersion = this.getGameVersion();
        result = result * 59 + ($gameVersion == null ? 43 : $gameVersion.hashCode());
        LaunchModifier $launchModifier = this.getLaunchModifier();
        result = result * 59 + ($launchModifier == null ? 43 : ((Object)$launchModifier).hashCode());
        List<FeaturePattern> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        FnPatternList $userFiles = this.getUserFiles();
        result = result * 59 + ($userFiles == null ? 43 : ((Object)$userFiles).hashCode());
        return result;
    }

    public String toString() {
        return "BuilderConfig(name=" + this.getName() + ", title=" + this.getTitle() + ", gameVersion=" + this.getGameVersion() + ", launchModifier=" + this.getLaunchModifier() + ", features=" + this.getFeatures() + ", userFiles=" + this.getUserFiles() + ")";
    }
}

