/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.office2003;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.ExtWindowsDesktopProperty;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.WindowsDesktopProperty;
import com.jidesoft.plaf.XPUtils;
import com.jidesoft.plaf.office2003.Office2003Theme;
import com.jidesoft.plaf.office2003.Office2003WindowsUtils;
import com.jidesoft.plaf.vsnet.ConvertListener;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;

public class DefaultOffice2003Theme
extends Office2003Theme {
    private static final double DAKRER_FACTOR = 0.76;
    private static final double FACTOR = 0.85;
    private static final double LIGHTER_FACTOR = 0.95;
    private static final double EVEN_LIGHTER_FACTOR = 0.97;
    private static boolean _useStandardSelectionColor;

    static Color getLighterColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        return ColorUtils.getDerivedColor(color, 0.93f);
    }

    public DefaultOffice2003Theme() {
        super("Default");
        if (!DefaultOffice2003Theme.isUseStandardSelectionColor()) {
            this.putDerivedSelectionColor();
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        WindowsDesktopProperty control = new WindowsDesktopProperty("win.3d.backgroundColor", UIDefaultsLookup.get("control"), toolkit);
        ExtWindowsDesktopProperty controlDk2 = new ExtWindowsDesktopProperty(new String[]{"win.3d.backgroundColor"}, new Object[]{UIDefaultsLookup.get("control")}, toolkit, new ConvertListener(){

            public Object convert(Object[] obj) {
                return DefaultOffice2003Theme.this.darker((Color)obj[0], 0.95);
            }
        });
        ExtWindowsDesktopProperty controlDk = new ExtWindowsDesktopProperty(new String[]{"win.3d.backgroundColor"}, new Object[]{UIDefaultsLookup.get("control")}, toolkit, new ConvertListener(){

            public Object convert(Object[] obj) {
                return DefaultOffice2003Theme.this.darker((Color)obj[0], 0.76);
            }
        });
        ExtWindowsDesktopProperty controlLt = new ExtWindowsDesktopProperty(new String[]{"win.3d.highlightColor"}, new Object[]{UIDefaultsLookup.get("controlLtHighlight")}, toolkit, new ConvertListener(){

            public Object convert(Object[] obj) {
                return DefaultOffice2003Theme.this.brighter((Color)obj[0], 0.85);
            }
        });
        WindowsDesktopProperty controlShadow = new WindowsDesktopProperty("win.3d.shadowColor", UIDefaultsLookup.get("controlShadow"), toolkit);
        ExtWindowsDesktopProperty controlDkShadow = new ExtWindowsDesktopProperty(new String[]{"win.3d.shadowColor"}, new Object[]{UIDefaultsLookup.get("controlShadow")}, toolkit, new ConvertListener(){

            public Object convert(Object[] obj) {
                return DefaultOffice2003Theme.this.darker((Color)obj[0], 0.85);
            }
        });
        WindowsDesktopProperty controlText = new WindowsDesktopProperty("win.button.textColor", UIDefaultsLookup.get("controlText"), toolkit);
        WindowsDesktopProperty controlLtHighlight = new WindowsDesktopProperty("win.3d.highlightColor", UIDefaultsLookup.get("controlLtHighlight"), toolkit);
        WindowsDesktopProperty commandBarCaption = new WindowsDesktopProperty("", UIDefaultsLookup.get("inactiveCaption"), toolkit);
        ExtWindowsDesktopProperty menuItemBackground = new ExtWindowsDesktopProperty(new String[]{"win.3d.backgroundColor"}, new Object[]{UIDefaultsLookup.get("control")}, toolkit, new ConvertListener(){

            public Object convert(Object[] obj) {
                return new ColorUIResource(DefaultOffice2003Theme.getLighterColor((Color)obj[0]));
            }
        });
        Object[] uiDefaults = new Object[]{"control", control, "controlLt", controlLt, "controlDk", control, "controlShadow", controlShadow, "OptionPane.bannerLt", new ColorUIResource(0, 52, 206), "OptionPane.bannerDk", new ColorUIResource(45, 96, 249), "OptionPane.bannerForeground", new ColorUIResource(255, 255, 255), "Separator.foreground", controlShadow, "Separator.foregroundLt", controlLt, "Gripper.foreground", controlShadow, "Gripper.foregroundLt", controlLt, "Chevron.backgroundLt", controlDk, "Chevron.backgroundDk", controlShadow, "Divider.backgroundLt", controlShadow, "Divider.backgroundDk", controlDkShadow, "backgroundLt", controlLt, "backgroundDk", control, "selection.border", controlShadow, "MenuItem.background", menuItemBackground, "DockableFrameTitlePane.backgroundLt", controlLt, "DockableFrameTitlePane.backgroundDk", controlDk2, "DockableFrameTitlePane.activeForeground", controlText, "DockableFrameTitlePane.inactiveForeground", controlText, "DockableFrame.backgroundLt", controlLt, "DockableFrame.backgroundDk", controlLt, "CommandBar.titleBarBackground", commandBarCaption};
        this.putDefaults(uiDefaults);
        int products = LookAndFeelFactory.getProductsUsed();
        if ((products & 2) != 0) {
            int SIZE2 = 20;
            int MASK_SIZE = 11;
            ImageIcon collapsiblePaneImage = IconsFactory.getImageIcon(Office2003WindowsUtils.class, "icons/collapsible_pane_default.png");
            ImageIcon collapsiblePaneMask = IconsFactory.getImageIcon(Office2003WindowsUtils.class, "icons/collapsible_pane_mask.png");
            ImageIcon normalIcon = IconsFactory.getIcon(null, collapsiblePaneImage, 0, 0, 20, 20);
            ImageIcon emphasizedIcon = IconsFactory.getIcon(null, collapsiblePaneImage, 20, 0, 20, 20);
            ImageIcon downMark = IconsFactory.getIcon(null, collapsiblePaneMask, 0, 0, 11, 11);
            ImageIcon upMark = IconsFactory.getIcon(null, collapsiblePaneMask, 0, 11, 11, 11);
            uiDefaults = new Object[]{"CollapsiblePane.contentBackground", controlLtHighlight, "CollapsiblePanes.backgroundLt", control, "CollapsiblePanes.backgroundDk", controlShadow, "CollapsiblePaneTitlePane.backgroundLt", controlLt, "CollapsiblePaneTitlePane.backgroundDk", control, "CollapsiblePaneTitlePane.foreground", controlText, "CollapsiblePaneTitlePane.foreground.focus", controlText, "CollapsiblePaneTitlePane.backgroundLt.emphasized", controlShadow, "CollapsiblePaneTitlePane.backgroundDk.emphasized", controlDkShadow, "CollapsiblePaneTitlePane.foreground.emphasized", controlLtHighlight, "CollapsiblePaneTitlePane.foreground.focus.emphasized", controlLtHighlight, "CollapsiblePane.downIcon", IconsFactory.getOverlayIcon(null, normalIcon, downMark, 0), "CollapsiblePane.upIcon", IconsFactory.getOverlayIcon(null, normalIcon, upMark, 0), "CollapsiblePane.downIcon.emphasized", IconsFactory.getOverlayIcon(null, emphasizedIcon, downMark, 0), "CollapsiblePane.upIcon.emphasized", IconsFactory.getOverlayIcon(null, emphasizedIcon, upMark, 0), "CollapsiblePane.upMask", upMark, "CollapsiblePane.downMask", downMark, "CollapsiblePane.titleButtonBackground", normalIcon, "CollapsiblePane.titleButtonBackground.emphasized", emphasizedIcon};
            this.putDefaults(uiDefaults);
        }
    }

    private void putDerivedSelectionColor() {
        UIDefaults.ActiveValue selectionRollover = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return UIDefaultsLookup.getColor("JideButton.focusedBackground");
            }
        };
        UIDefaults.ActiveValue selectionRolloverLt = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return DefaultOffice2003Theme.this.brighter(UIDefaultsLookup.getColor("JideButton.focusedBackground"), 0.95);
            }
        };
        UIDefaults.ActiveValue selectionRolloverDk = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return DefaultOffice2003Theme.this.darker(UIDefaultsLookup.getColor("JideButton.focusedBackground"), 0.95);
            }
        };
        UIDefaults.ActiveValue selectionSelected = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return UIDefaultsLookup.getColor("JideButton.selectedBackground");
            }
        };
        UIDefaults.ActiveValue selectionSelectedLt = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return DefaultOffice2003Theme.this.brighter(UIDefaultsLookup.getColor("JideButton.selectedBackground"), 0.95);
            }
        };
        UIDefaults.ActiveValue selectionSelectedDk = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return DefaultOffice2003Theme.this.darker(UIDefaultsLookup.getColor("JideButton.selectedBackground"), 0.95);
            }
        };
        UIDefaults.ActiveValue selectionSelectedAndFocused = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return UIDefaultsLookup.getColor("JideButton.selectedAndFocusedBackground");
            }
        };
        UIDefaults.ActiveValue selectionSelectedAndFocusedLt = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return DefaultOffice2003Theme.this.brighter(UIDefaultsLookup.getColor("JideButton.selectedAndFocusedBackground"), 0.95);
            }
        };
        UIDefaults.ActiveValue selectionSelectedAndFocusedDk = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return DefaultOffice2003Theme.this.darker(UIDefaultsLookup.getColor("JideButton.selectedAndFocusedBackground"), 0.95);
            }
        };
        Object[] uiDefaultsSelection = new Object[]{"selection.Rollover", selectionRollover, "selection.RolloverLt", selectionRolloverLt, "selection.RolloverDk", selectionRolloverDk, "selection.Selected", selectionSelected, "selection.SelectedLt", selectionSelectedLt, "selection.SelectedDk", selectionSelectedDk, "selection.Pressed", selectionSelectedAndFocused, "selection.PressedLt", selectionSelectedAndFocusedLt, "selection.PressedDk", selectionSelectedAndFocusedDk};
        this.putDefaults(uiDefaultsSelection);
    }

    private void removeDerivedSelectionColor() {
        Object[] uiDefaultsSelection;
        for (Object o : uiDefaultsSelection = new Object[]{"selection.Rollover", "selection.RolloverLt", "selection.RolloverDk", "selection.Selected", "selection.SelectedLt", "selection.SelectedDk", "selection.Pressed", "selection.PressedLt", "selection.PressedDk"}) {
            this.remove(o);
        }
    }

    private Color brighter(Color c, double factor) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / factor), 255), Math.min((int)((double)g / factor), 255), Math.min((int)((double)b / factor), 255));
    }

    private Color darker(Color c, double factor) {
        return new Color(Math.max((int)((double)c.getRed() * factor), 0), Math.max((int)((double)c.getGreen() * factor), 0), Math.max((int)((double)c.getBlue() * factor), 0));
    }

    public static boolean isUseStandardSelectionColor() {
        return _useStandardSelectionColor;
    }

    public static void setUseStandardSelectionColor(boolean useStandardSelectionColor) {
        _useStandardSelectionColor = useStandardSelectionColor;
    }

    static {
        try {
            _useStandardSelectionColor = XPUtils.isXPStyleOn();
        }
        catch (UnsupportedOperationException e) {
            _useStandardSelectionColor = false;
        }
    }
}

